//Exp 5.4 Program Title:Image Enhancement using neighbourhood processing high pass filter 
//environment: Scilab 5.5.2
//Toolbox: Image Processing Design 8.3.1-1
//Toolbox: SIVP 0.5.3.2
//Tested on OS: Windows 7 Professional, 64 bit
//Reference books names : 1)Digital Image Processing book author :
// Rafael C.Gonzalez and Richard E.Woods,
//2)Digital Image Processing book author :S.Sudhir,
//3)Digital Image Processing book author :Dhanajay Theckedath
clc //to clear command window.
clear all //to disable previously defined variables.
xdel(winsid());///clear all the previous figures plots
SIVP_PATH = getSIVPpath(); //to locate a directory in which SIVP toolbox is installed
im1=imread(SIVP_PATH + 'images/rose.bmp');//read  color image from diractory
im2=rgb2gray(im1);//grayscale image
im4=double(im2);
w=[-1 -1 -1; -1 8 -1; -1 -1 -1];//high pass filter mask
w1=[-2 -2 -2; -2 16 -2; -2 -2 -2];//high pass filter mask
[av1]=masking(im4,w);//convolution process
[av2]=masking(im4,w1);//convolution process
figure(1);ShowColorImage(im1,'Color image');title('Color image','color','red','fontsize',6);//IPD Toolbox
figure(2);ShowImage(im2,'greyscale image');title('greyscale image','color','red','fontsize',6);//IPD Toolbox
figure(3);ShowImage(av1,'High Pass filtered Image');title('High Pass filtered Image','color','red','fontsize',6);//IPD Toolbox
figure(4);ShowImage(av2,'High Pass filtered Image2');title('High Pass filtered Image2','color','red','fontsize',6);//IPD Toolbox
